const axios = require('axios');

class TgeBrowserAPI {
    constructor(baseUrl = 'http://127.0.0.1:50326', token = null) {
        this.baseUrl = baseUrl;
        this.headers = {
            'Authorization': `Bearer ${token}`,
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',
            'Content-Type': 'application/json'
        };
    }

    async createEnv() {
        const data = {
            browserName: "12345",
            proxy: {
                protocol: "socks5",
                host: "127.0.0.1",
                port: 7890
            },
            fingerprint: {
                os: "Windows",
                platformVersion: 11,
                kernel: "139",
                userAgent: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.9.2537 Safari/537.36",
                canvas: true,
                speechVoices: true,
                clientRects: true,
                resolution: "1920x1080",
                ram: 8,
                cpu: 4,
                language: "en-US",
                languageBaseIp: true,
                uiLanguage: "en-US",
                uiLanguageBaseIp: true,
                timezone: "Europe/Amsterdam",
                timezoneBaseIp: true,
                geolocationBaseIp: true,
                lng: "116.397128",
                lat: "39.916527",
                hardwareAcceleration: true,
                disableSandbox: false,
                startupParams: "",
                deviceMedia: false,
                deviceName: "DESKTOP-ABCD",
                randomFingerprint: false,
                disableImages: false,
                syncCookies: false
            },
            remark: "备注",
            Cookie: "",
            startInfo: {
                startPage: {
                    mode: "custom",
                    value: ["https://www.baidu.com"]
                },
                otherConfig: {
                    openConfigPage: true,
                    checkPage: true,
                    extensionTab: true
                }
            }
        };

        const response = await axios.post(`${this.baseUrl}/api/browser/create`, data, { headers: this.headers });
        return response.data;
    }

    async updateEnv(envId, newName = "修改后的环境") {
        const data = {
            envId: envId,
            proxy: {
                proxyId: 92852
            },
            remark: "更新备注"
        };

        const response = await axios.post(`${this.baseUrl}/api/browser/update`, data, { headers: this.headers });
        return response.data;
    }

    async startEnv(envId) {
        const data = {
            envId: envId
        };

        const response = await axios.post(`${this.baseUrl}/api/browser/start`, data, { headers: this.headers });
        return response.data;
    }

    async stopEnv(envId) {
        const data = { envId: envId };
        const response = await axios.post(`${this.baseUrl}/api/browser/stop`, data, { headers: this.headers });
        return response.data;
    }

    async deleteEnv(envId) {
        const data = { envId: envId };
        const response = await axios.post(`${this.baseUrl}/api/browser/delete`, data, { headers: this.headers });
        return response.data;
    }

    async deleteEnvCache(envId) {
        const data = { envId: envId };
        const response = await axios.post(`${this.baseUrl}/api/browser/cache/delete`, data, { headers: this.headers });
        return response.data;
    }

    async listEnvs(current = 1, pageSize = 20) {
        const response = await axios.get(
            `${this.baseUrl}/api/browser/list?current=${current}&pageSize=${pageSize}`,
            { headers: this.headers }
        );
        return response.data;
    }

    async listEnvsOpen(current = 1, pageSize = 20) {
        const response = await axios.get(
            `${this.baseUrl}/api/browser/open/list?current=${current}&pageSize=${pageSize}`,
            { headers: this.headers }
        );
        return response.data;
    }

    async listGroups(current = 1, pageSize = 20) {
        const response = await axios.get(
            `${this.baseUrl}/api/groups/list?current=${current}&pageSize=${pageSize}`,
            { headers: this.headers }
        );
        return response.data;
    }

    async listProxies(current = 1, pageSize = 20) {
        const response = await axios.get(
            `${this.baseUrl}/api/proxies/list?current=${current}&pageSize=${pageSize}`,
            { headers: this.headers }
        );
        return response.data;
    }

    async sortEnvs(envIds) {
        const data = { envIds: envIds };
        const response = await axios.post(
            `${this.baseUrl}/api/windowbounds/sort`,
            data,
            { headers: this.headers }
        );
        return response.data;
    }

    async customSortEnvs(envIds) {
        const data = {
            type: "box",
            startX: 0,
            startY: 0,
            width: 500,
            height: 400,
            col: 3,
            spaceX: 50,
            spaceY: 50,
            offsetX: 50,
            offsetY: 50,
            envIds: envIds
        };

        const response = await axios.post(
            `${this.baseUrl}/api/windowbounds/sort/custom`,
            data,
            { headers: this.headers }
        );
        return response.data;
    }
}

module.exports = TgeBrowserAPI;
