const TgeBrowserAPI = require('./TgeBrowserAPI');

async function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

async function main() {
    const token = 'asp_5ed069585d31a9c378179faa2529066f6b0b739296bd98af';
    const api = new TgeBrowserAPI('http://127.0.0.1:50326', token);
    
    console.log('\n=== 开始新的环境流程 ===');

    try {
        // 1. 创建环境
        const createRes = await api.createEnv();
        console.log('创建结果：', createRes);
        let envId = createRes.data.envId;

        // 2. 更新环境
        const updateRes = await api.updateEnv(envId);
        console.log('更新结果：', updateRes);
        envId = updateRes.data.envId;

        // 3. 启动环境
        console.log('\n=== 启动环境 ===');
        const startRes = await api.startEnv(envId);
        console.log(startRes);

        // 4. 查询环境列表
        console.log('\n=== 查询环境列表 ===');
        const listRes = await api.listEnvsOpen();
        console.log(listRes);

        // 5. 查询代理列表
        console.log('\n=== 查询代理列表 ===');
        const proxyList = await api.listProxies();
        console.log(proxyList);

        // 6. 模拟运行中...
        console.log('\n=== 模拟运行中... ===');
        await sleep(3000);

        // 7. 停止环境
        console.log('\n=== 停止环境 ===');
        const stopRes = await api.stopEnv(envId);
        console.log(stopRes);

        // 8. 删除环境
        console.log('\n=== 删除环境 ===');
        const deleteRes = await api.deleteEnv(envId);
        console.log(deleteRes);

        // 9. 删除环境缓存
        console.log('\n=== 删除环境缓存 ===');
        const cacheRes = await api.deleteEnvCache(envId);
        console.log(cacheRes);

        console.log('\n=== 本轮结束 ===');

    } catch (error) {
        console.error('发生错误:', error.message);
        if (error.response) {
            console.error('响应数据:', error.response.data);
        }
    }
}

if (require.main === module) {
    main();
}

module.exports = TgeBrowserAPI;
