const puppeteer = require('puppeteer');
const TgeBrowserAPI = require('./TgeBrowserAPI');

async function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

async function main() {
    // 初始化API客户端
    const api = new TgeBrowserAPI(
        'http://127.0.0.1:50326',
        'asp_5ed069585d31a9c378179faa2529066f6b0b739296bd98af'
    );

    // 窗口ID从窗口配置界面中复制，或者api创建后返回
    const envId = 1630;

    try {
        // 启动环境
        const res = await api.startEnv(envId);
        const ws = res.data.ws;
        console.log('ws address ==>>', ws);

        // 通过CDP连接到浏览器
        const browser = await puppeteer.connect({
            browserWSEndpoint: ws,
            defaultViewport: null
        });

        // 获取默认上下文
        const pages = await browser.pages();
        const context = browser.defaultBrowserContext();

        console.log('new page and goto baidu');

        // 创建新页面
        const page = await context.newPage();
        await page.goto('https://baidu.com');

        await sleep(2000);

        console.log('close page and browser');
        await page.close();

        await sleep(2000);

        // 断开浏览器连接
        await browser.disconnect();

        // 停止环境
        await api.stopEnv(envId);
        console.log('环境已停止');

    } catch (error) {
        console.error('发生错误:', error);
    }
}

main();
