const { Builder } = require('selenium-webdriver');
const chrome = require('selenium-webdriver/chrome');
const TgeBrowserAPI = require('./TgeBrowserAPI');

async function main() {
    // 初始化API客户端
    const api = new TgeBrowserAPI(
        'http://127.0.0.1:50326',
        'asp_5ed069585d31a9c378179faa2529066f6b0b739296bd98af'
    );

    // 窗口ID从窗口配置界面中复制，或者api创建后返回
    const envId = 1630;

    try {
        // 启动环境
        const res = await api.startEnv(envId);
        console.log('启动结果:', res);

        const driverPath = res.data.driver;
        const port = res.data.port;
        const debuggerAddress = `127.0.0.1:${port}`;

        // 配置Chrome选项
        const options = new chrome.Options();
        options.debuggerAddress(debuggerAddress);

        // 设置chromedriver路径
        const service = new chrome.ServiceBuilder(driverPath);

        // 创建WebDriver实例
        const driver = await new Builder()
            .forBrowser('chrome')
            .setChromeOptions(options)
            .setChromeService(service)
            .build();

        // 以下为PC模式下，打开baidu，输入 TgeBrowser，点击搜索的案例
        await driver.get('https://www.baidu.com/');

        const input = await driver.findElement({ id: 'chat-textarea' });
        await input.sendKeys('TgeBrowser');

        console.log('before click...');

        const btn = await driver.findElement({ id: 'chat-submit-button' });
        await btn.click();

        console.log('after click');

        // 等待一段时间后关闭
        await new Promise(resolve => setTimeout(resolve, 3000));

        await driver.quit();

        // 停止环境
        await api.stopEnv(envId);
        console.log('环境已停止');

    } catch (error) {
        console.error('发生错误:', error);
    }
}

main();
