import time

import requests


class TgeBrowserAPI:
    def __init__(self, base_url="http://127.0.0.1:50326", token=None):
        self.base_url = base_url
        self.headers = {
            'Authorization': f'Bearer {token}',
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) '
                          'AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',
            'Content-Type': 'application/json',
        }

    def create_env(self):
        data = {
            "browserName": "12345",
            "proxy": {
                "protocol": "socks5",
                "host": "127.0.0.1",
                "port": 7890,
                # "username": "xcdata01",
                # "password": "xcdata01",
                # "ipChecker": "https://ipinfo.io",
            },
            "fingerprint": {
                "os": "Windows",
                "platformVersion": 11,
                "kernel": "139",
                "userAgent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.9.2537 Safari/537.36",
                "canvas": True,
                "speechVoices": True,
                "clientRects": True,
                "resolution": "1920x1080",
                "ram": 8,
                "cpu": 4,
                "language": "en-US",
                "languageBaseIp": True,
                "uiLanguage": "en-US",
                "uiLanguageBaseIp": True,
                "timezone": "Europe/Amsterdam",
                "timezoneBaseIp": True,
                "geolocationBaseIp": True,
                "lng": "116.397128",
                "lat": "39.916527",
                "hardwareAcceleration": True,
                "disableSandbox": False,
                "startupParams": "",
                "deviceMedia": False,
                "deviceName": "DESKTOP-ABCD",
                "randomFingerprint": False,
                "disableImages": False,
                "syncCookies": False
            },
            # "groupId": 29,
            "remark": "备注",
            "Cookie": "",
            "startInfo": {
                "startPage": {
                    "mode": "custom",
                    "value": [
                        "https://www.baidu.com"
                    ]
                },
                "otherConfig": {
                    "openConfigPage": True,
                    "checkPage": True,
                    "extensionTab": True
                }
            }
        }
        response = requests.post(f'{self.base_url}/api/browser/create', headers=self.headers, json=data)
        return response.json()

    def update_env(self, env_id, new_name="修改后的环境"):
        data = {
            "envId": env_id,
            # "browserName": new_name,
            "proxy": {
                # "protocol": "socks5",
                # "host": "156.243.178.201",
                # "port":7189,
                # "username": "ejauwujsw",
                # "password": "65lhbnofwckm",
                # "ipChecker": "https://ipinfo.io",
                "proxyId": 92852
            },
            # "fingerprint":{
            #     "randomFingerprint":True
            # },
            "remark": "更新备注"
        }
        response = requests.post(f'{self.base_url}/api/browser/update', headers=self.headers, json=data)
        return response.json()

    def start_env(self, env_id):
        data = {
            "envId": env_id, 
            # "args": ["--headless"], "port": 9222
        }
        response = requests.post(f'{self.base_url}/api/browser/start', headers=self.headers, json=data)
        return response.json()

    def stop_env(self, env_id):
        data = {"envId": env_id}
        response = requests.post(f'{self.base_url}/api/browser/stop', headers=self.headers, json=data)
        return response.json()

    def delete_env(self, env_id):
        data = {"envId": env_id}
        response = requests.post(f'{self.base_url}/api/browser/delete', headers=self.headers, json=data)
        return response.json()

    def delete_env_cache(self, env_id):
        data = {"envId": env_id}
        response = requests.post(f'{self.base_url}/api/browser/cache/delete', headers=self.headers, json=data)
        return response.json()

    def list_envs(self, current=1, page_size=20):
        response = requests.get(
            f'{self.base_url}/api/browser/list?current={current}&pageSize={page_size}',
            headers=self.headers
        )
        return response.json()

    def list_envs_open(self, current=1, page_size=20):
        response = requests.get(
            f'{self.base_url}/api/browser/open/list?current={current}&pageSize={page_size}',
            headers=self.headers
        )
        return response.json()

    def list_groups(self, current=1, page_size=20):
        response = requests.get(
            f'{self.base_url}/api/groups/list?current={current}&pageSize={page_size}',
            headers=self.headers
        )
        return response.json()

    def list_proxies(self, current=1, page_size=20):
        response = requests.get(
            f'{self.base_url}/api/proxies/list?current={current}&pageSize={page_size}',
            headers=self.headers
        )
        return response.text

    def sort_envs(self, env_ids):
        data = {"envIds": env_ids}
        response = requests.post(
            f'{self.base_url}/api/windowbounds/sort',
            headers=self.headers,
            json=data
        )
        return response.json()

    def custom_sort_envs(self, env_ids):
        data = {
            "type": "box",
            "startX": 0,
            "startY": 0,
            "width": 500,
            "height": 400,
            "col": 3,
            "spaceX": 50,
            "spaceY": 50,
            "offsetX": 50,
            "offsetY": 50,
            "envIds": env_ids
        }
        response = requests.post(
            f'{self.base_url}/api/windowbounds/sort/custom',
            headers=self.headers,
            json=data
        )
        return response.text

def main():
    token = "asp_5ed069585d31a9c378179faa2529066f6b0b739296bd98af"
    api = TgeBrowserAPI(token=token)
    print("\n=== 开始新的环境流程 ===")

    # 1. 创建环境
    create_res = api.create_env()
    print("创建结果：", create_res)
    env_id = create_res["data"]["envId"]

    update_res = api.update_env(env_id)
    print("更新结果：", update_res)
    # env_id = 102683
    env_id = update_res["data"]["envId"]

    # 2. 启动环境
    print("\n=== 启动环境 ===")
    start_res = api.start_env(env_id)
    print(start_res)

    # 3. 查询环境列表
    print("\n=== 查询环境列表 ===")
    list_res = api.list_envs_open()
    print(list_res)

    # 4. 查询代理列表
    print("\n=== 查询代理列表 ===")
    proxy_list = api.list_proxies()
    print(proxy_list)

    # # 5. 运行一段时间
    print("\n=== 模拟运行中... ===")
    time.sleep(3)
    #
    # 6. 停止环境
    print("\n=== 停止环境 ===")
    stop_res = api.stop_env(env_id)
    print(stop_res)

    # 7. 删除环境
    print("\n=== 删除环境 ===")
    delete_res = api.delete_env(env_id)
    print(delete_res)

    # 8. 删除环境缓存
    print("\n=== 删除环境缓存 ===")
    cache_res = api.delete_env_cache(env_id)
    print(cache_res)
    #
    # print("\n=== 本轮结束，等待下次循环 ===")
    time.sleep(3)  # 等待10秒再下一轮


if __name__ == '__main__':
    main()
